/*
 * Toolkit GUI, an application built for operating pinkRF's signal generators.
 *
 * Contact: https://www.pinkrf.com/contact/
 * Copyright © 2018-2024 pinkRF B.V
 * GNU General Public License version 3.
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with this program. If not, see https://www.gnu.org/licenses/
 *
 * Author: Iordan Svechtarov
 */



#include <QApplication>
#include <QDebug>
#include <QFile>
#include <QCoreApplication>
#include <config_handler.h>
#include "gui_4channel.h"
#include "gui_1channel.h"
#include "gui_1channel_odc.h"
#include "gui_mainwindow.h"
#include "gui_minimal.h"

int main(int argc, char *argv[])
{
	QApplication a(argc, argv);

	#if defined	GUI_TOOLKIT
		MainWindow w;
	#elif defined GUI_1CHANNEL
		GUI_1channel w;
	#elif defined GUI_4CHANNEL
		GUI_4channel w;
	#elif defined GUI_1CHANNEL_ODC
		GUI_1channel_ODC w;
	#elif defined GUI_MINIMAL
	GUI_Minimal w;
	#endif

	qDebug() << "Main: [Reading config file]";
	ConfigHandler *config = new ConfigHandler(QCoreApplication::applicationDirPath() + "/config.txt");

	config->get_fullscreen_enabled() == false	? w.show() : w.showFullScreen();   //fullscreen
	config->get_cursor_enabled() == false		? w.setCursor(Qt::BlankCursor) : w.setCursor(Qt::ArrowCursor);

#if !defined(GUI_1CHANNEL) && !defined(GUI_4CHANNEL)
	qDebug() << "\n\nGUI initialization complete.";
	qDebug() << "============================\n";
#endif

	return a.exec();
}
